﻿questionnaireEditor.registerTimeFormatChangeEvent = function (itemPanel) {
    $(".v-setting[data-name=TimeFormat]", itemPanel).on("change", function () {
        questionnaireEditor.changeTimeFormat($(this));
    });
}

questionnaireEditor.changeTimeFormat = function (dateFormatControl) {
    if (dateFormatControl.val() != null && dateFormatControl.val() != "") {
        var parentControl = dateFormatControl.closest(".v-blockItemPanel");

        $(".v-minMaxValue.v-calendar", parentControl).val("");
        $(".v-setting.v-minMaxSettings", parentControl).val("");

        var dateType = $(".v-dateType", parentControl).val();
        var timeFormat = dateFormatControl.val();

        if (dateType == "Time") {
            $(".v-calendar", parentControl).each(function () {
                $(this).val("");
                questionnaireEditor.setTimePicker($(this), timeFormat);
            });
        }
        else {
            $(".v-calendar", parentControl).each(function () {
                $(this).val("");
                var dateFormat = $(".v-setting[data-name=DateFormat]", parentControl).val();
                dateFormat = dateFormat.replace(/yy/g, "y").toLowerCase();
                questionnaireEditor.setDateTimePicker($(this), dateFormat, timeFormat);
            });
        }
    }
}

questionnaireEditor.registerDateFormatChangeEvent = function (parent, itemPanel) {
    $(".v-setting[data-name=DateFormat]", itemPanel).on("change", function () {
        questionnaireEditor.changeDateFormat($(this), parent);
    });
}

questionnaireEditor.changeDateFormat = function (dateformatControl, context) {
    $(".v-minMaxValue.v-calendar", context).val("");
    $(".v-setting.v-minMaxSettings", context).val("");
    questionnaireEditor.setDateType($(".v-dateType", context), false);

    var dateFormat = dateformatControl.val();
    dateFormat = dateFormat.replace(/yy/g, "y").toLowerCase();

    questionnaireEditor.disabledDateControl.changeDateFormat(dateFormat);

    var today = questionnaireEditor.disabledDateControl.today();

    $(".v-minMaxSelector").each(function () {
        var parent = $(this).closest(".v-minMaxValueContainer");
        var selectedValue = $(this).val();
        if (selectedValue == "TodayValue") {
            if (parent.hasClass("h-MinValue")) {
                questionnaireEditor.disabledDateControl.updateMinDate(today);
            }
            else if (parent.hasClass("h-MaxValue")) {
                questionnaireEditor.disabledDateControl.updateMaxDate(today);
            }
        }
    });
}

questionnaireEditor.registerDateAnswerTypeChangeEvent = function (context) {
    $(context).on("change", ".v-dateType", function () {
        questionnaireEditor.changeDateType($(this));
    });
}

questionnaireEditor.changeDateType = function (dateTypeControl) {
    var parentControl = dateTypeControl.closest(".v-blockItemPanel");
    var dateType = dateTypeControl.val();

    $(".v-minMaxValueContainer", parentControl).each(function () {
        questionnaireEditor.setMinMaxInitialValue(dateTypeControl);
    });

    questionnaireEditor.setDateType(dateTypeControl, true);

    if (!$('.v-advanceSettings').is(":visible")) {
        displayQuestionAdvanceSettings(parentControl, false, function () { questionnaireEditor.clearDateAdvancedSettings(dateType); });
    }
    else {
        questionnaireEditor.clearDateAdvancedSettings(dateType);
    }

    questionnaireEditor.toggleDisabledDatesControl(dateType);
}



questionnaireEditor.setDateType = function (dateTypeControl, reset) {
    var parentControl = dateTypeControl.closest(".v-blockItemPanel");
    var dateType = dateTypeControl.val();
    $(".v-dateSetting, .v-timeSetting", parentControl).hide();


    $(".v-calendar", parentControl).each(function () {
        if (dateType != "Date" && dateType != "Time" && dateType != "DateTime") {
            $(this).datepicker("destroy");
            $(this).addClass("v-validatePositiveInt");
            $(".v-setting[data-name=DateFormat] option:first", parentControl).prop("selected", true);
            $(".v-setting[data-name=TimeFormat] option:first", parentControl).prop("selected", true);
        }
        else {
            if (reset) {
                $(this).val("");
            }

            $(this).removeClass("v-validatePositiveInt");
            var dateFormat = $(".v-setting[data-name=DateFormat]", parentControl).val();
            dateFormat = dateFormat.replace(/yy/g, "y").toLowerCase();

            var timeFormat = $(".v-setting[data-name=TimeFormat]", parentControl).val();

            if (dateType == "Date") {
                questionnaireEditor.setDatePicker($(this), dateFormat);
                $(".v-dateSetting", parentControl).show();
            }
            else if (dateType == "Time") {
                questionnaireEditor.setTimePicker($(this), timeFormat);
                $(".v-timeSetting", parentControl).show();
            }
            else {
                questionnaireEditor.setDateTimePicker($(this), dateFormat, timeFormat);
                $(".v-dateSetting, .v-timeSetting", parentControl).show();
            }
        }
    });
}



questionnaireEditor.updateDisabledDateMinMax = function (dataName, value) {
    if (dataName == "MinValue")
        questionnaireEditor.disabledDateControl.updateMinDate(value);
    else if (dataName == "MaxValue")
        questionnaireEditor.disabledDateControl.updateMaxDate(value);
}

questionnaireEditor.setDatePicker = function (input, format) {
    input.datepicker("destroy");
    input.datepicker({
        changeMonth: true,
        changeYear: true,
        dateFormat: format,
        onClose: function () {
            var dataName = input.closest('.v-minMaxValueContainer').find('input:hidden.v-setting').attr('id');
            questionnaireEditor.updateDisabledDateMinMax(dataName, $(this).val());
        }
    });
}

questionnaireEditor.setTimePicker = function (input, format) {
    input.timepicker("destroy");
    input.timepicker({
        stepMinute: 5,
        ampm: format.indexOf("t") != -1,
        timeFormat: format
    });
}

questionnaireEditor.setDateTimePicker = function (input, dateFormat, timeFormat) {
    input.datetimepicker("destroy");
    input.datetimepicker({
        changeMonth: true,
        changeYear: true,
        stepMinute: 5,
        ampm: timeFormat.indexOf("t") != -1,
        dateFormat: dateFormat,
        timeFormat: timeFormat,
        onClose: function () {
            var dataName = input.closest('.v-minMaxValueContainer').find('input:hidden.v-setting').attr('id');
            questionnaireEditor.updateDisabledDateMinMax(dataName, $(this).val());
        }
    });
}



questionnaireEditor.toggleDisabledDatesControl = function (dateType) {
    if (!questionnaireEditor.disabledDateControl)
        return;
    else if (dateType == "Date" || dateType == "DateTime") {
        questionnaireEditor.disabledDateControl.show();
    }
    else {
        questionnaireEditor.disabledDateControl.hide();
    }
}

questionnaireEditor.clearDateAdvancedSettings = function (dataType) {
    questionnaireEditor.toggleDisabledDatesControl(dataType);
    questionnaireEditor.updateDisabledDateMinMax("MinValue", "");
    questionnaireEditor.updateDisabledDateMinMax("MaxValue", "");
    $('.v-minMaxValue').val('');
    $('.v-minMaxSelector').val('EnterValue');
}

questionnaireEditor.setDisableDateControl = function (parent) {
    questionnaireEditor.disabledDateControl = new a4DisableDatesControl();
    var dateFormat = $(".v-setting[data-name=DateFormat]", parent).val();
    dateFormat = dateFormat.replace(/yy/g, "y").toLowerCase();
    questionnaireEditor.disabledDateControl.init(parent, dateFormat);

    questionnaireEditor.disabledDateControl.updateMinDate(questionnaireEditor.getValidatedMinMaxDateValue($('#MinValue').val()));
    questionnaireEditor.disabledDateControl.updateMaxDate(questionnaireEditor.getValidatedMinMaxDateValue($('#MaxValue').val()));
}

//questionnaireEditor.setDateFormat = function (context) {
//    $(context).on("change", ".v-setting[data-name=DateFormat]", function () {
//        if ($(this).val() != null && $(this).val() != "") {
//            var parentControl = $(this).closest(".v-blockItemPanel");
//            var dateType = $(".v-dateType", parentControl).val();
//            var dateFormat = $(this).val().replace(/yy/g, "y").toLowerCase();

//            if (dateType == "Date") {
//                $(".v-calendar", parentControl).each(function () {
//                    $(this).val("");
//                    questionnaireEditor.setDatePicker($(this), dateFormat);
//                });
//            }
//            else {
//                $(".v-calendar", parentControl).each(function () {
//                    $(this).val("");
//                    var timeFormat = $(".v-setting[data-name=TimeFormat]", parentControl).val();
//                    questionnaireEditor.setDateTimePicker($(this), dateFormat, timeFormat);
//                });
//            }
//        }
//    });
//}